<?php
namespace Pantheon\Checks;

use Pantheon\Utils;
use Pantheon\Checkimplementation;
use Pantheon\Messenger;
use Pantheon\View;

class Exploited extends Checkimplementation {

	public function init() {
		$this->name = 'exploited';
		$this->action = 'No exploits found.';
		$this->description = 'Looking for exploited files.';
		$this->score = 0;
		$this->result = '';
		$this->label = 'Probable exploits';
		$this->key = 'exploits';
		$this->alerts = array();
		self::$instance = $this;
		return $this;
	}

	public function run($file) {
		$regex = 'eval\(.*base64_decode\(.*';
		$file_contents = $file->getContents();
		preg_match('#'.$regex.'#', $file_contents, $matches, PREG_OFFSET_CAPTURE );
		if ( $matches ) {
			foreach ($matches as $match) {
				$linenum = substr_count(substr($file_contents, 0, $match[1]), "\n") + 1;
				$this->alerts[] = array('class'=> 'warning', 'data'=> array($file->getRelativePathname(), $linenum, substr($match[0],0,50)));
			}
		}
		return $this;
	}

	public function message(Messenger $messenger) {
		if (!empty($this->alerts)) {
			$details = sprintf( "Found %s files that contain likely exploits \n\t-> %s",
				count($this->alerts),
				View::make('table',array('headers'=>array('File','Line','Match'),'rows'=> $this->alerts))
			);
			$this->score = 2;
			$this->result .= $details;
			$this->action = "You should deactivate this plugin unless you can verify this is the intended use.";
		} else {
			$this->result .= "No exploits found.";
		}
		$messenger->addMessage(get_object_vars($this));
	}
}
